/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.server.services;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityDimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfoEx;
import org.orecruncher.dsurround.network.Network;
import org.orecruncher.dsurround.network.PacketThunder;
import org.orecruncher.dsurround.network.PacketWeatherUpdate;
import org.orecruncher.lib.PlayerUtils;
import org.orecruncher.lib.random.XorShiftRandom;

public class WeatherGenerator {
    protected final Random RANDOM = XorShiftRandom.current();
    protected final World world;
    protected final IDimensionInfoEx data;

    public WeatherGenerator(@Nonnull World world) {
        this.world = world;
        this.data = (IDimensionInfoEx)CapabilityDimensionInfo.getCapability(world);
    }

    @Nonnull
    public String name() {
        return "STANDARD";
    }

    protected int nextThunderEvent(float rainIntensity) {
        float scale = 2.0f - rainIntensity;
        return this.RANDOM.nextInt((int)(450.0f * scale)) + 300;
    }

    protected boolean doFlash(float rainIntensity) {
        int randee = (int)(rainIntensity * 100.0f);
        return this.RANDOM.nextInt(150) <= randee;
    }

    protected WorldInfo worldInfo() {
        return this.world.func_72912_H();
    }

    protected void preProcess() {
    }

    protected void doRain() {
        if (this.worldInfo().func_76059_o()) {
            if (this.data.getRainIntensity() == 0.0f) {
                this.data.randomizeRain();
                ModBase.log().debug("dim %d rain intensity set to %f, duration %d ticks", new Object[]{this.data.getId(), Float.valueOf(this.data.getRainIntensity()), this.worldInfo().func_76083_p()});
            }
            this.data.setCurrentRainIntensity(this.world.func_72867_j(1.0f));
        } else if (this.world.func_72867_j(1.0f) > 0.0f) {
            this.data.setCurrentRainIntensity(this.world.func_72867_j(1.0f));
        } else if (this.data.getCurrentRainIntensity() > 0.0f) {
            this.data.setRainIntensity(0.0f);
            this.data.setCurrentRainIntensity(0.0f);
            ModBase.log().debug("dim %d rain has stopped, next rain %d ticks", new Object[]{this.data.getId(), this.worldInfo().func_76083_p()});
        } else if (this.data.getRainIntensity() > 0.0f) {
            this.data.setRainIntensity(0.0f);
        }
    }

    protected void doAmbientThunder() {
        if (!ModOptions.rain.allowBackgroundThunder) {
            return;
        }
        float intensity = this.data.getCurrentRainIntensity();
        if (this.worldInfo().func_76061_m() && intensity >= ModOptions.rain.stormThunderThreshold) {
            int time = this.data.getThunderTimer() - 1;
            if (time <= 0) {
                if (time == 0) {
                    EntityPlayer player2 = PlayerUtils.getRandomPlayer((World)this.world);
                    float theY = this.data.getSkyHeight();
                    if (player2 != null) {
                        PacketThunder packet = new PacketThunder(this.data.getId(), this.doFlash(intensity), new BlockPos(player2.field_70165_t, (double)theY, player2.field_70161_v));
                        Network.sendToDimension(this.data.getId(), packet);
                    }
                }
                time = this.nextThunderEvent(intensity);
            }
            this.data.setThunderTimer(time);
        } else {
            this.data.setThunderTimer(0);
        }
    }

    protected void postProcess() {
    }

    public final void update() {
        this.process();
        this.sendUpdate();
    }

    protected void process() {
        this.preProcess();
        this.doRain();
        this.doAmbientThunder();
        this.postProcess();
    }

    protected void sendUpdate() {
        if (this.world.field_73010_i.size() > 0) {
            PacketWeatherUpdate packet = new PacketWeatherUpdate(this.data.getId(), this.data.getCurrentRainIntensity(), this.data.getRainIntensity(), this.worldInfo().func_76083_p(), this.world.func_72819_i(1.0f), this.worldInfo().func_76071_n(), this.data.getThunderTimer());
            Network.sendToDimension(this.data.getId(), packet);
        }
    }
}

