/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.scanners;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.lib.scanner.RandomScanner;
import org.orecruncher.dsurround.lib.scanner.ScanLocus;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;
import org.orecruncher.dsurround.registry.blockstate.BlockStateUtil;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class RandomBlockEffectScanner
extends RandomScanner {
    private static final int ITERATION_COUNT = 667;
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;

    public RandomBlockEffectScanner(@Nonnull ScanLocus locus, int range) {
        super(locus, "RandomBlockScanner: " + range, range, 667);
        this.setLogger(ModBase.log());
    }

    @Override
    protected boolean interestingBlock(@Nonnull IBlockState state) {
        return ((BlockStateData)BlockStateUtil.getStateData(state)).hasSoundsOrEffects();
    }

    @Override
    public void blockScan(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        SoundEffect sound2;
        IBlockAccessEx provider = this.locus.getWorld();
        Object profile = BlockStateUtil.getStateData(state);
        BlockEffect[] effects2 = ((BlockStateData)profile).getEffects();
        if (effects2 != BlockStateData.NO_EFFECTS) {
            for (int i = 0; i < effects2.length; ++i) {
                BlockEffect be = effects2[i];
                if (!be.canTrigger(provider, state, pos, rand)) continue;
                be.doEffect(provider, state, pos, rand);
            }
        }
        if ((sound2 = ((BlockStateData)profile).getSoundToPlay(rand)) != null) {
            sound2.doEffect(provider, state, pos, rand);
        }
    }
}

