/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.speech.ISpeechData;
import org.orecruncher.dsurround.capabilities.speech.SpeechData;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.capability.CapabilityProviderSerializable;
import org.orecruncher.lib.capability.CapabilityUtils;
import org.orecruncher.lib.capability.NullStorage;

public final class CapabilitySpeechData {
    @CapabilityInject(value=ISpeechData.class)
    public static final Capability<ISpeechData> SPEECH_DATA = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "speech");

    @SideOnly(value=Side.CLIENT)
    public static void register() {
        CapabilityManager.INSTANCE.register(ISpeechData.class, (Capability.IStorage)new NullStorage(), SpeechData::new);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISpeechData getCapability(@Nonnull Entity entity) {
        return (ISpeechData)CapabilityUtils.getCapability((ICapabilityProvider)entity, SPEECH_DATA, null);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public static ICapabilityProvider createProvider(ISpeechData data) {
        return new CapabilityProviderSerializable(SPEECH_DATA, null, (Object)data);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCandidate(@Nonnull Entity entity) {
        return entity instanceof EntityPlayer || entity instanceof EntityLiving;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCandidate(@Nullable Class<? extends Entity> clazz) {
        return clazz != null && (EntityPlayer.class.isAssignableFrom(clazz) || EntityLiving.class.isAssignableFrom(clazz));
    }

    @Mod.EventBusSubscriber(modid="dsurround", value={Side.CLIENT})
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(@Nonnull AttachCapabilitiesEvent<Entity> event) {
            World world = ((Entity)event.getObject()).func_130014_f_();
            if (world != null && world.field_72995_K && CapabilitySpeechData.isCandidate((Entity)event.getObject())) {
                SpeechData speechData = new SpeechData();
                event.addCapability(CAPABILITY_ID, CapabilitySpeechData.createProvider(speechData));
            }
        }

        @SubscribeEvent(receiveCanceled=false)
        public static void livingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
            Entity entity = event.getEntity();
            World world = entity.func_130014_f_();
            if (!world.field_72995_K || entity.field_70173_aa % 5 != 0) {
                return;
            }
            ISpeechData data = CapabilitySpeechData.getCapability(event.getEntity());
            if (data != null) {
                data.onUpdate(EnvironStateHandler.EnvironState.getTickCounter());
            }
        }
    }
}

