/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContextBase;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.InternalCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.NodeStack;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.NodeStackRecording;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeFunc;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IVariableNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.NodeTypes;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncObjectLongLongToLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncObjectLongToLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncObjectObjectToObject;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncObjectToLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncToBoolean;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncToDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncToLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func.NodeFuncToObject;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantBoolean;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantObject;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableBoolean;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class FunctionContext
extends FunctionContextBase {
    public static final String FUNCTION_ARG_SEPARATOR = "@";
    public final String name;
    private final FunctionContext[] parents;
    private final Map<String, IExpressionNode> variables = new HashMap<String, IExpressionNode>();
    private final Map<String, Map<List<Class<?>>, INodeFunc>> functions = new HashMap();

    @Deprecated
    public FunctionContext() {
        this("");
    }

    @Deprecated
    public FunctionContext(FunctionContext parent) {
        this("", parent);
    }

    @Deprecated
    public FunctionContext(FunctionContext ... parents) {
        this("", parents);
    }

    public FunctionContext(String name) {
        this.name = name;
        this.parents = new FunctionContext[0];
    }

    public FunctionContext(String name, FunctionContext parent) {
        this.name = name;
        this.parents = new FunctionContext[]{parent};
    }

    public FunctionContext(String name, FunctionContext ... parents) {
        this.name = name;
        this.parents = (FunctionContext[])parents.clone();
    }

    public FunctionContext[] getParents() {
        return this.parents;
    }

    public IExpressionNode getVariable(String name) {
        IExpressionNode current = this.variables.get(name = name.toLowerCase(Locale.ROOT));
        if (current != null) {
            return current;
        }
        for (FunctionContext parent : this.parents) {
            IExpressionNode node = parent.getVariable(name);
            if (node == null) continue;
            return node;
        }
        INodeFunc func = this.getFunction(name, Collections.emptyList());
        if (func != null) {
            try {
                return func.getNode(new NodeStack());
            }
            catch (InvalidExpressionException e) {
                throw new IllegalStateException("Found a 0-args function that didn't allow us to get a node for it!", e);
            }
        }
        return null;
    }

    public boolean hasLocalVariable(String name) {
        name = name.toLowerCase(Locale.ROOT);
        return this.variables.containsKey(name);
    }

    public <E extends IExpressionNode> E putVariable(String name, E node) {
        if (NodeTypes.getType(name = name.toLowerCase(Locale.ROOT)) != null) {
            throw new IllegalArgumentException("Cannot add a variable that clashes with a type! (Name = '" + name + "', Types = " + NodeTypes.getValidTypeNames() + ")");
        }
        this.variables.put(name, node);
        return node;
    }

    public IVariableNode putVariable(String name, Class<?> type) {
        if (type == Boolean.TYPE) {
            return this.putVariableBoolean(name);
        }
        if (type == Long.TYPE) {
            return this.putVariableLong(name);
        }
        if (type == Double.TYPE) {
            return this.putVariableDouble(name);
        }
        return this.putVariableObject(name, type);
    }

    public NodeVariableLong putVariableLong(String name) {
        NodeVariableLong node = new NodeVariableLong(name);
        return this.putVariable(name, node);
    }

    public NodeVariableDouble putVariableDouble(String name) {
        NodeVariableDouble node = new NodeVariableDouble(name);
        return this.putVariable(name, node);
    }

    public NodeVariableBoolean putVariableBoolean(String name) {
        NodeVariableBoolean node = new NodeVariableBoolean(name);
        return this.putVariable(name, node);
    }

    public NodeVariableObject<String> putVariableString(String name) {
        return this.putVariableObject(name, String.class);
    }

    public <T> NodeVariableObject<T> putVariableObject(String name, Class<T> type) {
        NodeVariableObject<T> node = new NodeVariableObject<T>(name, type);
        return this.putVariable(name, node);
    }

    public void putConstantLong(final String name, long value) {
        this.putVariable(name, new NodeConstantLong(value){

            @Override
            public String toString() {
                return name;
            }
        });
    }

    public void putConstantDouble(final String name, double value) {
        this.putVariable(name, new NodeConstantDouble(value){

            @Override
            public String toString() {
                return name;
            }
        });
    }

    public void putConstantBoolean(final String name, final boolean value) {
        this.putVariable(name, new IExpressionNode.INodeBoolean(){

            @Override
            public boolean evaluate() {
                return value;
            }

            @Override
            public IExpressionNode.INodeBoolean inline() {
                return NodeConstantBoolean.of(value);
            }

            public String toString() {
                return name;
            }
        });
    }

    public <T> void putConstant(String name, Class<T> type, T value) {
        this.putVariable(name, new NodeConstantObject<T>(type, value));
    }

    public void putParsedConstant(String name, String value) {
        if (InternalCompiler.isValidLong(value)) {
            this.putConstantLong(name, InternalCompiler.parseValidLong(value));
        } else if (InternalCompiler.isValidDouble(value)) {
            this.putConstantDouble(name, Double.parseDouble(value));
        } else if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            this.putConstantBoolean(name, "true".equalsIgnoreCase(value));
        } else {
            this.putConstant(name, String.class, value);
        }
    }

    public Set<String> getAllVariables() {
        return this.variables.keySet();
    }

    public INodeFunc getFunction(String name, List<Class<?>> args) {
        INodeFunc func;
        Map<List<Class<?>>, INodeFunc> map = this.functions.get(name);
        if (map != null && (func = map.get(args)) != null) {
            return func;
        }
        for (FunctionContext parent : this.parents) {
            INodeFunc func2 = parent.getFunction(name, args);
            if (func2 == null) continue;
            return func2;
        }
        return null;
    }

    public Map<List<Class<?>>, INodeFunc> getFunctions(String name) {
        name = name.toLowerCase(Locale.ROOT);
        HashMap map = new HashMap();
        this.getFunctions0(name, map);
        return map;
    }

    public Map<String, Map<List<Class<?>>, INodeFunc>> getAllFunctions() {
        return this.functions;
    }

    private void getFunctions0(String name, Map<List<Class<?>>, INodeFunc> map) {
        for (FunctionContext parent : this.parents) {
            parent.getFunctions0(name, map);
        }
        Map<List<Class<?>>, INodeFunc> all = this.functions.get(name);
        if (all != null) {
            map.putAll(all);
        }
    }

    private static List<Class<?>> getArgTypes(INodeFunc function) {
        NodeStackRecording recorder = new NodeStackRecording();
        try {
            function.getNode(recorder);
        }
        catch (InvalidExpressionException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
        ArrayList types = new ArrayList(recorder.types);
        Collections.reverse(types);
        return types;
    }

    @Override
    public <F extends INodeFunc> F putFunction(String name, F function) {
        name = name.toLowerCase(Locale.ROOT);
        Map map = this.functions.computeIfAbsent(name, k -> new HashMap());
        map.put(FunctionContext.getArgTypes(function), function);
        return function;
    }

    public INodeFunc.INodeFuncLong put_l(String name, NodeFuncToLong.IFuncToLong func) {
        return this.putFunction(name, new NodeFuncToLong(name, func));
    }

    public INodeFunc.INodeFuncDouble put_d(String name, NodeFuncToDouble.IFuncToDouble func) {
        return this.putFunction(name, new NodeFuncToDouble(name, func));
    }

    public INodeFunc.INodeFuncBoolean put_b(String name, NodeFuncToBoolean.IFuncToBoolean func) {
        return this.putFunction(name, new NodeFuncToBoolean(name, func));
    }

    public INodeFunc.INodeFuncObject<String> put_s(String name, Supplier<String> func) {
        return this.put_o(name, String.class, func);
    }

    public <T> INodeFunc.INodeFuncObject<T> put_o(String name, Class<T> type, Supplier<T> func) {
        return this.putFunction(name, new NodeFuncToObject<T>(name, type, func));
    }

    public INodeFunc.INodeFuncLong put_s_l(String name, NodeFuncObjectToLong.IFuncObjectToLong<String> func) {
        return this.put_o_l(name, String.class, func);
    }

    public INodeFunc.INodeFuncLong put_sl_l(String name, NodeFuncObjectLongToLong.IFuncObjectLongToLong<String> func) {
        return this.put_ol_l(name, String.class, func);
    }

    public INodeFunc.INodeFuncLong put_sl_l(String name, NodeFuncObjectLongLongToLong.IFuncObjectLongLongToLong<String> func) {
        return this.put_oll_l(name, String.class, func);
    }

    public INodeFunc.INodeFuncObject<String> put_ss_s(String name, NodeFuncObjectObjectToObject.IFuncObjectObjectToObject<String, String, String> func) {
        return this.put_oo_o(name, String.class, String.class, String.class, func);
    }
}

