/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.BakedAction;
import alexiil.mc.mod.load.baked.BakedConfig;
import alexiil.mc.mod.load.baked.BakedFactory;
import alexiil.mc.mod.load.baked.BakedRenderingPart;
import alexiil.mc.mod.load.baked.BakedVariable;
import alexiil.mc.mod.load.json.JsonAction;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.JsonRenderingPart;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import net.minecraft.util.ResourceLocation;

public class JsonConfig
extends JsonConfigurable<JsonConfig, BakedConfig> {
    public final JsonRenderingPart[] renders;
    public final String[] functions;
    public final JsonFactory[] factories;
    public final JsonAction[] actions;
    public final JsonVariable[] variables;

    public JsonConfig(JsonRenderingPart[] renders, String[] functions, JsonFactory[] factories, JsonAction[] actions, JsonVariable[] variables) {
        this.renders = renders;
        this.functions = functions;
        this.factories = factories;
        this.actions = actions;
        this.variables = variables;
    }

    public JsonConfig(JsonConfig parent, JsonRenderingPart[] renders, String[] functions, JsonFactory[] factories, JsonAction[] actions, JsonVariable[] variables) {
        this.renders = JsonConfig.consolidateArray(parent == null ? null : parent.renders, renders);
        this.functions = JsonConfig.consolidateArray(parent == null ? null : parent.functions, functions);
        this.factories = JsonConfig.consolidateArray(parent == null ? null : parent.factories, factories);
        this.actions = JsonConfig.consolidateArray(parent == null ? null : parent.actions, actions);
        this.variables = JsonConfig.consolidateArray(parent == null ? null : parent.variables, variables);
    }

    @Override
    public void setLocation(ResourceLocation location) {
        super.setLocation(location);
        location = this.resourceLocation;
        for (JsonVariable jsonVariable : this.variables) {
            jsonVariable.setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.renders) {
            ((JsonRenderingPart)jsonConfigurable).setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.factories) {
            ((JsonFactory)jsonConfigurable).setLocation(location);
        }
        for (JsonConfigurable jsonConfigurable : this.actions) {
            jsonConfigurable.setLocation(location);
        }
    }

    @Override
    protected BakedConfig actuallyBake(FunctionContext context) throws InvalidExpressionException {
        BakedFactory[] factories;
        BakedAction[] actions;
        BakedVariable[] vars = new BakedVariable[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            vars[i] = (BakedVariable)this.variables[i].bake(context);
        }
        BakedRenderingPart[] array = new BakedRenderingPart[this.renders.length];
        for (int i = 0; i < this.renders.length; ++i) {
            JsonRenderingPart jrp = this.renders[i];
            array[i] = (BakedRenderingPart)jrp.bake(context);
        }
        if (this.actions == null || this.actions.length == 0) {
            actions = new BakedAction[]{};
        } else {
            actions = new BakedAction[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                JsonAction ja = this.actions[i];
                actions[i] = (BakedAction)ja.bake(context);
            }
        }
        if (this.factories == null || this.factories.length == 0) {
            factories = new BakedFactory[]{};
        } else {
            factories = new BakedFactory[this.factories.length];
            for (int i = 0; i < this.factories.length; ++i) {
                JsonFactory jf = this.factories[i];
                factories[i] = (BakedFactory)jf.bake(context);
            }
        }
        return new BakedConfig(vars, array, actions, factories);
    }
}

