/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.zenscript.expand;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.chat.IChatMessage;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.formatting.IFormattedText;
import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenExpansion(value="string")
@ZenRegister
public class ExpandString {
    @ZenOperator(value=OperatorType.ADD)
    public static IFormattedText add(String str, IFormattedText formattedText) {
        return CraftTweakerAPI.format.string(str).add(formattedText);
    }

    @ZenOperator(value=OperatorType.CAT)
    public static IFormattedText cat(String str, IFormattedText formattedText) {
        return ExpandString.add(str, formattedText);
    }

    @ZenCaster
    public static IData asData(String value) {
        return new DataString(value);
    }

    @ZenCaster
    public static IChatMessage asChatMessage(String value) {
        return CrafttweakerImplementationAPI.platform.getMessage(value);
    }

    @ZenCaster
    public static IFormattedText asFormattedText(String value) {
        return CraftTweakerAPI.format.string(value);
    }

    @ZenMethod
    public static List<String> split(String value, String separator, @Optional int maximum) {
        int index;
        ArrayList<String> result = new ArrayList<String>();
        int minIndex = 0;
        int numSplits = 0;
        while (minIndex + separator.length() <= value.length() && (index = value.indexOf(separator, minIndex)) >= 0) {
            result.add(value.substring(minIndex, index));
            minIndex = index + separator.length();
            if (maximum <= 0 || ++numSplits < maximum) continue;
            break;
        }
        result.add(value.substring(minIndex));
        return result;
    }

    @ZenMethod
    public static int indexOf(String value, String needle) {
        return value.indexOf(needle);
    }

    @ZenMethod
    public static int indexOf(String value, String needle, int fromIndex) {
        return value.indexOf(needle, fromIndex);
    }

    @ZenMethod
    public static int lastIndexOf(String value, String needle) {
        return value.lastIndexOf(needle);
    }

    @ZenMethod
    public static int lastIndexOf(String value, String needle, int fromIndex) {
        return value.lastIndexOf(value, fromIndex);
    }
}

