/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.transformers;

import guichaguri.betterfps.BetterFpsConfig;
import guichaguri.betterfps.BetterFpsHelper;
import guichaguri.betterfps.transformers.ASMUtils;
import guichaguri.betterfps.transformers.Conditions;
import guichaguri.betterfps.tweaker.BetterFpsTweaker;
import guichaguri.betterfps.tweaker.Mappings;
import java.io.InputStream;
import java.util.LinkedHashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MathTransformer
implements IClassTransformer {
    private static final LinkedHashMap<BetterFpsConfig.AlgorithmType, String> algorithmClasses = new LinkedHashMap();
    private final String METHOD_SIN = "sin";
    private final String METHOD_COS = "cos";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (Mappings.C_MathHelper.is(name)) {
            try {
                return this.patchMath(bytes);
            }
            catch (Exception ex) {
                BetterFpsHelper.LOG.error("Couldn't patch math algorithms", (Throwable)ex);
            }
        }
        return bytes;
    }

    private byte[] patchMath(byte[] bytes) throws Exception {
        BetterFpsConfig config = BetterFpsHelper.getConfig();
        String algorithmClass = algorithmClasses.get((Object)config.algorithm);
        if (algorithmClass == null) {
            BetterFpsHelper.LOG.error("The algorithm is invalid. We're going to use Vanilla Algorithm instead.");
            config.algorithm = BetterFpsConfig.AlgorithmType.VANILLA;
            return bytes;
        }
        if (config.algorithm == BetterFpsConfig.AlgorithmType.VANILLA) {
            BetterFpsHelper.LOG.info("No algorithm for patching, Vanilla Algorithm will be used");
            return bytes;
        }
        BetterFpsHelper.LOG.info("Patching math utils with \"{}\" algorithm", (Object)config.algorithm);
        InputStream in = BetterFpsTweaker.getResourceStream(algorithmClass + ".class");
        if (in == null) {
            return bytes;
        }
        ClassNode mathClass = ASMUtils.readClass(IOUtils.toByteArray((InputStream)in), 0);
        ClassNode classNode = ASMUtils.readClass(bytes, 0);
        MethodNode init = ASMUtils.findMethod(classNode, "<clinit>", "()V");
        MethodNode sin = ASMUtils.findMethod(classNode, Mappings.M_sin);
        MethodNode cos = ASMUtils.findMethod(classNode, Mappings.M_cos);
        boolean patchedSin = false;
        boolean patchedCos = false;
        for (FieldNode f : mathClass.fields) {
            ASMUtils.copyField(mathClass, classNode, f, true);
        }
        for (MethodNode m2 : mathClass.methods) {
            if (m2.name.equals("sin")) {
                if (sin != null) {
                    m2.name = sin.name;
                }
                ASMUtils.copyMethod(mathClass, classNode, m2, sin, true);
                patchedSin = true;
            } else if (m2.name.equals("cos")) {
                if (cos != null) {
                    m2.name = cos.name;
                }
                ASMUtils.copyMethod(mathClass, classNode, m2, cos, true);
                patchedCos = true;
            } else if (m2.name.equals("<clinit>")) {
                m2.name = "init";
                ASMUtils.appendMethod(mathClass, classNode, m2, init);
            } else {
                ASMUtils.copyMethod(mathClass, classNode, m2, true);
            }
            if (sin != null) {
                this.replaceCallReferences(classNode.name, "sin", sin.name, m2);
            }
            if (cos == null) continue;
            this.replaceCallReferences(classNode.name, "cos", cos.name, m2);
        }
        FieldNode sinTable = ASMUtils.findField(classNode, Mappings.F_SIN_TABLE);
        if (patchedSin && patchedCos && sinTable != null && init != null) {
            classNode.fields.remove(sinTable);
            InsnList inst = init.instructions;
            LabelNode currentLabel = null;
            for (int i = 0; i < inst.size(); ++i) {
                AbstractInsnNode node = inst.get(i);
                if (node instanceof LabelNode) {
                    currentLabel = (LabelNode)node;
                    continue;
                }
                if (!(node instanceof FieldInsnNode) || currentLabel == null) continue;
                FieldInsnNode f = (FieldInsnNode)node;
                if (!classNode.name.equals(f.owner) || !sinTable.name.equals(f.name) || !sinTable.desc.equals(f.desc)) continue;
                i = inst.indexOf((AbstractInsnNode)currentLabel);
                ASMUtils.removeLabelSection(inst, currentLabel);
            }
        }
        Conditions.patched.add(Mappings.C_MathHelper);
        return ASMUtils.writeClass(classNode, 0);
    }

    private void replaceCallReferences(String clazz, String needle, String replacement, MethodNode method) {
        InsnList list = method.instructions;
        for (int i = 0; i < list.size(); ++i) {
            AbstractInsnNode node = list.get(i);
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode m2 = (MethodInsnNode)node;
            if (!m2.owner.equals(clazz) || !m2.name.equals(needle)) continue;
            m2.name = replacement;
        }
    }

    static {
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.RIVENS, "guichaguri/betterfps/math/RivensMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.TAYLORS, "guichaguri/betterfps/math/TaylorMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.LIBGDX, "guichaguri/betterfps/math/LibGDXMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.RIVENS_FULL, "guichaguri/betterfps/math/RivensFullMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.RIVENS_HALF, "guichaguri/betterfps/math/RivensHalfMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.JAVA, "guichaguri/betterfps/math/JavaMath");
        algorithmClasses.put(BetterFpsConfig.AlgorithmType.RANDOM, "guichaguri/betterfps/math/RandomMath");
    }
}

