/*
 * Decompiled with CFR 0.152.
 */
package dongle12.miscrails.rails.powered_rails;

import dongle12.miscrails.rails.powered_rails.PoweredRail;
import dongle12.miscrails.util.ConfigHandler;
import dongle12.miscrails.util.RailUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JumpRail
extends PoweredRail {
    public int jumpStrength = 1;

    public JumpRail() {
        super("jump_rail");
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        float retSpeed = 0.4f;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos nextPos = pos.func_177972_a(side);
            boolean foundRail = RailUtil.FoundRail(world, nextPos);
            if (!foundRail) {
                if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177984_a();
                } else if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177977_b();
                }
            }
            if (!foundRail) continue;
            BlockRailBase.EnumRailDirection dir = RailUtil.RailDirection(world, cart, pos);
            BlockRailBase.EnumRailDirection dirNext = RailUtil.RailDirection(world, cart, nextPos);
            retSpeed = dir != null && dir.func_177018_c() || dirNext != null && dirNext.func_177018_c() ? 0.6f : super.getRailMaxSpeed(world, cart, pos) * ConfigHandler.POWERED_SPEED_RAIL_MULTIPLIER;
        }
        return retSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public void cycleJumpStrength(boolean forward) {
        if (forward) {
            if (this.jumpStrength < ConfigHandler.MAX_JUMP_RAIL_STRENGTH) {
                ++this.jumpStrength;
            }
        } else if (this.jumpStrength > 0) {
            --this.jumpStrength;
        }
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)BlockRailPowered.field_176569_M)).booleanValue()) {
            return;
        }
        cart.field_70181_x = (double)this.jumpStrength * 0.1;
        cart.setDragAir(1.0);
    }
}

